/*
 * Decompiled with CFR 0.152.
 */
package com.android.product.data.repository;

import com.android.core.data.AndroidRepository;
import com.android.product.domain.model.ProductGroupDto;
import com.service.SettingLoader;
import com.utility.DbConnection;
import com.utility.Paging;
import org.springframework.stereotype.Component;

@Component
public class ProductGroupRepository
extends AndroidRepository<ProductGroupDto> {
    public ProductGroupRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    protected Paging.PageSqlData queryWithDefaultPaging(SettingLoader settingsLoader) {
        if (settingsLoader.sendProductsDisabled()) {
            return null;
        }
        boolean isActiveMenu = settingsLoader.isSendActiveResMenuProducts();
        String joins = isActiveMenu ? "LEFT JOIN article a ON Ra.A_Code = a.A_Code \nINNER JOIN Res_MenuCategory RM ON ra.A_Type = RM.A_Type \n" : "INNER JOIN ARTICLE a ON SubString(A.A_Code, 1, 2) = M.M_GroupCode \nINNER JOIN S_Group S ON M.M_GroupCode = S.M_GroupCode \nAND SubString(a.A_Code, 3, 2) = S.S_GroupCode ";
        joins = joins + (settingsLoader.userHasLimitedAccessToProducts() ? "INNER JOIN (SELECT * FROM RMUserArtAccess WHERE UserId = " + settingsLoader.getLogin().getUserCodeInc() + " AND IsNull(DataTypeId, 0) = 0) RMUa ON RMUa.ArticleId = a.A_Code" : "");
        if (isActiveMenu) {
            return Paging.PageSqlData.builder().selectSqlStr("SELECT DISTINCT 0 AS id, Ra.A_Type AS code, \nLTrim(Rtrim(RM.A_Type_Name)) AS title, '' AS mainGroupTitle FROM  Res_MenuArt Ra \n").whereStr("ISNULL(a.UseInPortable, 0) = 1 AND Isnull(Ra.IsActive, 0) = 1 \nAND ISNULL(RM.IsActive, 0) = 1").joinsStr(joins).alias("Ra").keyField("[code]").groupBy("[code]").build();
        }
        return Paging.PageSqlData.builder().selectSqlStr("SELECT distinct 0 AS id, (M.M_groupcode + S.S_groupcode) AS code, LTrim(Rtrim(S.S_groupname)) AS title, LTrim(Rtrim(M.M_groupname)) AS mainGroupTitle FROM M_GROUP M\n").whereStr("ISNULL(a.UseInPortable, 0) = 1").joinsStr(joins).alias("M").keyField("[code]").keyFieldType("nvarchar(4)").build();
    }
}

